/*! For license information please see editor-props.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/node_modules/jsonschema/lib/attribute.js":function(e,r,t){var s=t("./packages/node_modules/jsonschema/lib/helpers.js"),o=s.ValidatorResult,a=s.SchemaError,n={ignoreProperties:{id:!0,default:!0,description:!0,title:!0,additionalItems:!0,then:!0,else:!0,$schema:!0,$ref:!0,extends:!0}},i=n.validators={};function testSchemaNoThrow(e,r,t,s,o){var a=r.throwError,n=r.throwAll;r.throwError=!1,r.throwAll=!1;var i=this.validateSchema(e,o,r,t);return r.throwError=a,r.throwAll=n,!i.valid&&s instanceof Function&&s(i),i.valid}function getEnumerableProperty(e,r){if(Object.hasOwnProperty.call(e,r))return e[r];if(r in e)for(;e=Object.getPrototypeOf(e);)if(Object.propertyIsEnumerable.call(e,r))return e[r]}function testAdditionalProperty(e,r,t,s,o,a){if(this.types.object(e)&&(!r.properties||void 0===r.properties[o]))if(!1===r.additionalProperties)a.addError({name:"additionalProperties",argument:o,message:"is not allowed to have the additional property "+JSON.stringify(o)});else{var n=r.additionalProperties||{};"function"==typeof t.preValidateProperty&&t.preValidateProperty(e,o,n,t,s);var i=this.validateSchema(e[o],n,t,s.makeChild(n,o));i.instance!==a.instance[o]&&(a.instance[o]=i.instance),a.importErrors(i)}}i.type=function validateType(e,r,t,s){if(void 0===e)return null;var a=new o(e,r,t,s),n=Array.isArray(r.type)?r.type:[r.type];if(!n.some(this.testType.bind(this,e,r,t,s))){var i=n.map(function(e){if(e){var r=e.$id||e.id;return r?"<"+r+">":e+""}});a.addError({name:"type",argument:i,message:"is not of a type(s) "+i})}return a},i.anyOf=function validateAnyOf(e,r,t,s){if(void 0===e)return null;var n=new o(e,r,t,s),i=new o(e,r,t,s);if(!Array.isArray(r.anyOf))throw new a("anyOf must be an array");if(!r.anyOf.some(testSchemaNoThrow.bind(this,e,t,s,function(e){i.importErrors(e)}))){var p=r.anyOf.map(function(e,r){var t=e.$id||e.id;return t?"<"+t+">":e.title&&JSON.stringify(e.title)||e.$ref&&"<"+e.$ref+">"||"[subschema "+r+"]"});t.nestedErrors&&n.importErrors(i),n.addError({name:"anyOf",argument:p,message:"is not any of "+p.join(",")})}return n},i.allOf=function validateAllOf(e,r,t,s){if(void 0===e)return null;if(!Array.isArray(r.allOf))throw new a("allOf must be an array");var n=new o(e,r,t,s),i=this;return r.allOf.forEach(function(r,o){var a=i.validateSchema(e,r,t,s);if(!a.valid){var p=r.$id||r.id||r.title&&JSON.stringify(r.title)||r.$ref&&"<"+r.$ref+">"||"[subschema "+o+"]";n.addError({name:"allOf",argument:{id:p,length:a.errors.length,valid:a},message:"does not match allOf schema "+p+" with "+a.errors.length+" error[s]:"}),n.importErrors(a)}}),n},i.oneOf=function validateOneOf(e,r,t,s){if(void 0===e)return null;if(!Array.isArray(r.oneOf))throw new a("oneOf must be an array");var n=new o(e,r,t,s),i=new o(e,r,t,s),p=r.oneOf.filter(testSchemaNoThrow.bind(this,e,t,s,function(e){i.importErrors(e)})).length,c=r.oneOf.map(function(e,r){return e.$id||e.id||e.title&&JSON.stringify(e.title)||e.$ref&&"<"+e.$ref+">"||"[subschema "+r+"]"});return 1!==p&&(t.nestedErrors&&n.importErrors(i),n.addError({name:"oneOf",argument:c,message:"is not exactly one from "+c.join(",")})),n},i.if=function validateIf(e,r,t,a){if(void 0===e)return null;if(!s.isSchema(r.if))throw new Error('Expected "if" keyword to be a schema');var n,i=testSchemaNoThrow.call(this,e,t,a,null,r.if),p=new o(e,r,t,a);if(i){if(void 0===r.then)return;if(!s.isSchema(r.then))throw new Error('Expected "then" keyword to be a schema');n=this.validateSchema(e,r.then,t,a.makeChild(r.then)),p.importErrors(n)}else{if(void 0===r.else)return;if(!s.isSchema(r.else))throw new Error('Expected "else" keyword to be a schema');n=this.validateSchema(e,r.else,t,a.makeChild(r.else)),p.importErrors(n)}return p},i.propertyNames=function validatePropertyNames(e,r,t,n){if(this.types.object(e)){var i=new o(e,r,t,n),p=void 0!==r.propertyNames?r.propertyNames:{};if(!s.isSchema(p))throw new a('Expected "propertyNames" to be a schema (object or boolean)');for(var c in e)if(void 0!==getEnumerableProperty(e,c)){var l=this.validateSchema(c,p,t,n.makeChild(p));i.importErrors(l)}return i}},i.properties=function validateProperties(e,r,t,s){if(this.types.object(e)){var n=new o(e,r,t,s),i=r.properties||{};for(var p in i){var c=i[p];if(void 0!==c){if(null===c)throw new a('Unexpected null, expected schema in "properties"');"function"==typeof t.preValidateProperty&&t.preValidateProperty(e,p,c,t,s);var l=getEnumerableProperty(e,p),u=this.validateSchema(l,c,t,s.makeChild(c,p));u.instance!==n.instance[p]&&(n.instance[p]=u.instance),n.importErrors(u)}}return n}},i.patternProperties=function validatePatternProperties(e,r,t,s){if(this.types.object(e)){var n=new o(e,r,t,s),i=r.patternProperties||{};for(var p in e){var c=!0;for(var l in i){var u=i[l];if(void 0!==u){if(null===u)throw new a('Unexpected null, expected schema in "patternProperties"');try{var d=new RegExp(l,"u")}catch(e){d=new RegExp(l)}if(d.test(p)){c=!1,"function"==typeof t.preValidateProperty&&t.preValidateProperty(e,p,u,t,s);var m=this.validateSchema(e[p],u,t,s.makeChild(u,p));m.instance!==n.instance[p]&&(n.instance[p]=m.instance),n.importErrors(m)}}}c&&testAdditionalProperty.call(this,e,r,t,s,p,n)}return n}},i.additionalProperties=function validateAdditionalProperties(e,r,t,s){if(this.types.object(e)){if(r.patternProperties)return null;var a=new o(e,r,t,s);for(var n in e)testAdditionalProperty.call(this,e,r,t,s,n,a);return a}},i.minProperties=function validateMinProperties(e,r,t,s){if(this.types.object(e)){var a=new o(e,r,t,s);return Object.keys(e).length>=r.minProperties||a.addError({name:"minProperties",argument:r.minProperties,message:"does not meet minimum property length of "+r.minProperties}),a}},i.maxProperties=function validateMaxProperties(e,r,t,s){if(this.types.object(e)){var a=new o(e,r,t,s);return Object.keys(e).length<=r.maxProperties||a.addError({name:"maxProperties",argument:r.maxProperties,message:"does not meet maximum property length of "+r.maxProperties}),a}},i.items=function validateItems(e,r,t,s){var a=this;if(this.types.array(e)&&void 0!==r.items){var n=new o(e,r,t,s);return e.every(function(e,o){if(Array.isArray(r.items))var i=void 0===r.items[o]?r.additionalItems:r.items[o];else i=r.items;if(void 0===i)return!0;if(!1===i)return n.addError({name:"items",message:"additionalItems not permitted"}),!1;var p=a.validateSchema(e,i,t,s.makeChild(i,o));return p.instance!==n.instance[o]&&(n.instance[o]=p.instance),n.importErrors(p),!0}),n}},i.contains=function validateContains(e,r,t,a){var n=this;if(this.types.array(e)&&void 0!==r.contains){if(!s.isSchema(r.contains))throw new Error('Expected "contains" keyword to be a schema');var i=new o(e,r,t,a);return!1===e.some(function(e,s){return 0===n.validateSchema(e,r.contains,t,a.makeChild(r.contains,s)).errors.length})&&i.addError({name:"contains",argument:r.contains,message:"must contain an item matching given schema"}),i}},i.minimum=function validateMinimum(e,r,t,s){if(this.types.number(e)){var a=new o(e,r,t,s);return r.exclusiveMinimum&&!0===r.exclusiveMinimum?e>r.minimum||a.addError({name:"minimum",argument:r.minimum,message:"must be greater than "+r.minimum}):e>=r.minimum||a.addError({name:"minimum",argument:r.minimum,message:"must be greater than or equal to "+r.minimum}),a}},i.maximum=function validateMaximum(e,r,t,s){if(this.types.number(e)){var a=new o(e,r,t,s);return r.exclusiveMaximum&&!0===r.exclusiveMaximum?e<r.maximum||a.addError({name:"maximum",argument:r.maximum,message:"must be less than "+r.maximum}):e<=r.maximum||a.addError({name:"maximum",argument:r.maximum,message:"must be less than or equal to "+r.maximum}),a}},i.exclusiveMinimum=function validateExclusiveMinimum(e,r,t,s){if("boolean"!=typeof r.exclusiveMinimum&&this.types.number(e)){var a=new o(e,r,t,s);return e>r.exclusiveMinimum||a.addError({name:"exclusiveMinimum",argument:r.exclusiveMinimum,message:"must be strictly greater than "+r.exclusiveMinimum}),a}},i.exclusiveMaximum=function validateExclusiveMaximum(e,r,t,s){if("boolean"!=typeof r.exclusiveMaximum&&this.types.number(e)){var a=new o(e,r,t,s);return e<r.exclusiveMaximum||a.addError({name:"exclusiveMaximum",argument:r.exclusiveMaximum,message:"must be strictly less than "+r.exclusiveMaximum}),a}};var p=function validateMultipleOfOrDivisbleBy(e,r,t,n,i,p){if(this.types.number(e)){var c=r[i];if(0==c)throw new a(i+" cannot be zero");var l=new o(e,r,t,n),u=s.getDecimalPlaces(e),d=s.getDecimalPlaces(c),m=Math.max(u,d),f=Math.pow(10,m);return Math.round(e*f)%Math.round(c*f)!==0&&l.addError({name:i,argument:c,message:p+JSON.stringify(c)}),l}};function testArrays(e,r,t){var o,a=t.length;for(o=r+1;o<a;o++)if(s.deepCompareStrict(e,t[o]))return!1;return!0}i.multipleOf=function validateMultipleOf(e,r,t,s){return p.call(this,e,r,t,s,"multipleOf","is not a multiple of (divisible by) ")},i.divisibleBy=function validateDivisibleBy(e,r,t,s){return p.call(this,e,r,t,s,"divisibleBy","is not divisible by (multiple of) ")},i.required=function validateRequired(e,r,t,s){var a=new o(e,r,t,s);return void 0===e&&!0===r.required?a.addError({name:"required",message:"is required"}):this.types.object(e)&&Array.isArray(r.required)&&r.required.forEach(function(r){void 0===getEnumerableProperty(e,r)&&a.addError({name:"required",argument:r,message:"requires property "+JSON.stringify(r)})}),a},i.pattern=function validatePattern(e,r,t,s){if(this.types.string(e)){var a=new o(e,r,t,s),n=r.pattern;try{var i=new RegExp(n,"u")}catch(e){i=new RegExp(n)}return e.match(i)||a.addError({name:"pattern",argument:r.pattern,message:"does not match pattern "+JSON.stringify(r.pattern.toString())}),a}},i.format=function validateFormat(e,r,t,a){if(void 0!==e){var n=new o(e,r,t,a);return n.disableFormat||s.isFormat(e,r.format,this)||n.addError({name:"format",argument:r.format,message:"does not conform to the "+JSON.stringify(r.format)+" format"}),n}},i.minLength=function validateMinLength(e,r,t,s){if(this.types.string(e)){var a=new o(e,r,t,s),n=e.match(/[\uDC00-\uDFFF]/g);return e.length-(n?n.length:0)>=r.minLength||a.addError({name:"minLength",argument:r.minLength,message:"does not meet minimum length of "+r.minLength}),a}},i.maxLength=function validateMaxLength(e,r,t,s){if(this.types.string(e)){var a=new o(e,r,t,s),n=e.match(/[\uDC00-\uDFFF]/g);return e.length-(n?n.length:0)<=r.maxLength||a.addError({name:"maxLength",argument:r.maxLength,message:"does not meet maximum length of "+r.maxLength}),a}},i.minItems=function validateMinItems(e,r,t,s){if(this.types.array(e)){var a=new o(e,r,t,s);return e.length>=r.minItems||a.addError({name:"minItems",argument:r.minItems,message:"does not meet minimum length of "+r.minItems}),a}},i.maxItems=function validateMaxItems(e,r,t,s){if(this.types.array(e)){var a=new o(e,r,t,s);return e.length<=r.maxItems||a.addError({name:"maxItems",argument:r.maxItems,message:"does not meet maximum length of "+r.maxItems}),a}},i.uniqueItems=function validateUniqueItems(e,r,t,s){if(!0===r.uniqueItems&&this.types.array(e)){var a=new o(e,r,t,s);return e.every(testArrays)||a.addError({name:"uniqueItems",message:"contains duplicate item"}),a}},i.dependencies=function validateDependencies(e,r,t,s){if(this.types.object(e)){var a=new o(e,r,t,s);for(var n in r.dependencies)if(void 0!==e[n]){var i=r.dependencies[n],p=s.makeChild(i,n);if("string"==typeof i&&(i=[i]),Array.isArray(i))i.forEach(function(r){void 0===e[r]&&a.addError({name:"dependencies",argument:p.propertyPath,message:"property "+r+" not found, required by "+p.propertyPath})});else{var c=this.validateSchema(e,i,t,p);a.instance!==c.instance&&(a.instance=c.instance),c&&c.errors.length&&(a.addError({name:"dependencies",argument:p.propertyPath,message:"does not meet dependency required by "+p.propertyPath}),a.importErrors(c))}}return a}},i.enum=function validateEnum(e,r,t,n){if(void 0===e)return null;if(!Array.isArray(r.enum))throw new a("enum expects an array",r);var i=new o(e,r,t,n);return r.enum.some(s.deepCompareStrict.bind(null,e))||i.addError({name:"enum",argument:r.enum,message:"is not one of enum values: "+r.enum.map(String).join(",")}),i},i.const=function validateEnum(e,r,t,a){if(void 0===e)return null;var n=new o(e,r,t,a);return s.deepCompareStrict(r.const,e)||n.addError({name:"const",argument:r.const,message:"does not exactly match expected constant: "+r.const}),n},i.not=i.disallow=function validateNot(e,r,t,s){var a=this;if(void 0===e)return null;var n=new o(e,r,t,s),i=r.not||r.disallow;return i?(Array.isArray(i)||(i=[i]),i.forEach(function(o){if(a.testType(e,r,t,s,o)){var i=o&&(o.$id||o.id)||o;n.addError({name:"not",argument:i,message:"is of prohibited type "+i})}}),n):null},e.exports=n},"./packages/node_modules/jsonschema/lib/helpers.js":function(e,r){var t=r.ValidationError=function ValidationError(e,r,t,s,o,a){if(Array.isArray(s)?(this.path=s,this.property=s.reduce(function(e,r){return e+i(r)},"instance")):void 0!==s&&(this.property=s),e&&(this.message=e),t){var n=t.$id||t.id;this.schema=n||t}void 0!==r&&(this.instance=r),this.name=o,this.argument=a,this.stack=this.toString()};t.prototype.toString=function toString(){return this.property+" "+this.message};var s=r.ValidatorResult=function ValidatorResult(e,r,t,s){this.instance=e,this.schema=r,this.options=t,this.path=s.path,this.propertyPath=s.propertyPath,this.errors=[],this.throwError=t&&t.throwError,this.throwFirst=t&&t.throwFirst,this.throwAll=t&&t.throwAll,this.disableFormat=t&&!0===t.disableFormat};function stringizer(e,r){return r+": "+e.toString()+"\n"}function ValidatorResultError(e){"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,ValidatorResultError),this.instance=e.instance,this.schema=e.schema,this.options=e.options,this.errors=e.errors}s.prototype.addError=function addError(e){var r;if("string"==typeof e)r=new t(e,this.instance,this.schema,this.path);else{if(!e)throw new Error("Missing error detail");if(!e.message)throw new Error("Missing error message");if(!e.name)throw new Error("Missing validator type");r=new t(e.message,this.instance,this.schema,this.path,e.name,e.argument)}if(this.errors.push(r),this.throwFirst)throw new ValidatorResultError(this);if(this.throwError)throw r;return r},s.prototype.importErrors=function importErrors(e){"string"==typeof e||e&&e.validatorType?this.addError(e):e&&e.errors&&(this.errors=this.errors.concat(e.errors))},s.prototype.toString=function toString(e){return this.errors.map(stringizer).join("")},Object.defineProperty(s.prototype,"valid",{get:function(){return!this.errors.length}}),e.exports.ValidatorResultError=ValidatorResultError,ValidatorResultError.prototype=new Error,ValidatorResultError.prototype.constructor=ValidatorResultError,ValidatorResultError.prototype.name="Validation Error";var o=r.SchemaError=function SchemaError(e,r){this.message=e,this.schema=r,Error.call(this,e),"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,SchemaError)};o.prototype=Object.create(Error.prototype,{constructor:{value:o,enumerable:!1},name:{value:"SchemaError",enumerable:!1}});var a=r.SchemaContext=function SchemaContext(e,r,t,s,o){this.schema=e,this.options=r,Array.isArray(t)?(this.path=t,this.propertyPath=t.reduce(function(e,r){return e+i(r)},"instance")):this.propertyPath=t,this.base=s,this.schemas=o};a.prototype.resolve=function resolve(e){return(()=>p(this.base,e))()},a.prototype.makeChild=function makeChild(e,r){var t=void 0===r?this.path:this.path.concat([r]),s=e.$id||e.id;let o=(()=>p(this.base,s||""))();var n=new a(e,this.options,t,o,Object.create(this.schemas));return s&&!n.schemas[o]&&(n.schemas[o]=e),n};var n=r.FORMAT_REGEXPS={"date-time":/^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,date:/^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,time:/^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,duration:/P(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S)|\d+(D|M(\d+D)?|Y(\d+M(\d+D)?)?)(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S))?|\d+W)/i,email:/^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,"idn-email":/^("(?:[!#-\[\]-\u{10FFFF}]|\\[\t -\u{10FFFF}])*"|[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*)@([!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*|\[[!-Z\^-\u{10FFFF}]*\])$/u,"ip-address":/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,ipv6:/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,uri:/^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,"uri-reference":/^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,iri:/^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,"iri-reference":/^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~-\u{10FFFF}]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~-\u{10FFFF}])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/u,uuid:/^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i,"uri-template":/(%[0-9a-f]{2}|[!#$&(-;=?@\[\]_a-z~]|\{[!#&+,./;=?@|]?(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?(,(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?)*\})*/iu,"json-pointer":/^(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*$/iu,"relative-json-pointer":/^\d+(#|(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*)$/iu,hostname:/^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,"host-name":/^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,"utc-millisec":function(e){return"string"==typeof e&&parseFloat(e)===parseInt(e,10)&&!isNaN(e)},regex:function(e){var r=!0;try{new RegExp(e)}catch(e){r=!1}return r},style:/[\r\n\t ]*[^\r\n\t ][^:]*:[\r\n\t ]*[^\r\n\t ;]*[\r\n\t ]*;?/,color:/^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,phone:/^\+(?:[0-9] ?){6,14}[0-9]$/,alpha:/^[a-zA-Z]+$/,alphanumeric:/^[a-zA-Z0-9]+$/};n.regexp=n.regex,n.pattern=n.regex,n.ipv4=n["ip-address"],r.isFormat=function isFormat(e,r,t){if("string"==typeof e&&void 0!==n[r]){if(n[r]instanceof RegExp)return n[r].test(e);if("function"==typeof n[r])return n[r](e)}else if(t&&t.customFormats&&"function"==typeof t.customFormats[r])return t.customFormats[r](e);return!0};var i=r.makeSuffix=function makeSuffix(e){return(e=e.toString()).match(/[.\s\[\]]/)||e.match(/^[\d]/)?e.match(/^\d+$/)?"["+e+"]":"["+JSON.stringify(e)+"]":"."+e};function deepMerger(e,r,t,s){"object"==typeof t?r[s]=deepMerge(e[s],t):-1===e.indexOf(t)&&r.push(t)}function copyist(e,r,t){r[t]=e[t]}function copyistWithDeepMerge(e,r,t,s){"object"==typeof r[s]&&r[s]&&e[s]?t[s]=deepMerge(e[s],r[s]):t[s]=r[s]}function deepMerge(e,r){var t=Array.isArray(r),s=t&&[]||{};return t?(e=e||[],s=s.concat(e),r.forEach(deepMerger.bind(null,e,s))):(e&&"object"==typeof e&&Object.keys(e).forEach(copyist.bind(null,e,s)),Object.keys(r).forEach(copyistWithDeepMerge.bind(null,e,r,s))),s}function pathEncoder(e){return"/"+encodeURIComponent(e).replace(/~/g,"%7E")}r.deepCompareStrict=function deepCompareStrict(e,r){if(typeof e!=typeof r)return!1;if(Array.isArray(e))return!!Array.isArray(r)&&(e.length===r.length&&e.every(function(t,s){return deepCompareStrict(e[s],r[s])}));if("object"==typeof e){if(!e||!r)return e===r;var t=Object.keys(e),s=Object.keys(r);return t.length===s.length&&t.every(function(t){return deepCompareStrict(e[t],r[t])})}return e===r},e.exports.deepMerge=deepMerge,r.objectGetPath=function objectGetPath(e,r){for(var t,s=r.split("/").slice(1);"string"==typeof(t=s.shift());){var o=decodeURIComponent(t.replace(/~0/,"~").replace(/~1/g,"/"));if(!(o in e))return;e=e[o]}return e},r.encodePath=function encodePointer(e){return e.map(pathEncoder).join("")},r.getDecimalPlaces=function getDecimalPlaces(e){var r=0;if(isNaN(e))return r;"number"!=typeof e&&(e=Number(e));var t=e.toString().split("e");if(2===t.length){if("-"!==t[1][0])return r;r=Number(t[1].slice(1))}var s=t[0].split(".");return 2===s.length&&(r+=s[1].length),r},r.isSchema=function isSchema(e){return"object"==typeof e&&e||"boolean"==typeof e};var p=r.resolveUrl=function resolveUrl(e,r){const t=new URL(r,new URL(e,"resolve://"));if("resolve:"===t.protocol){const{pathname:e,search:r,hash:s}=t;return e+r+s}return t.toString()}},"./packages/node_modules/jsonschema/lib/index.js":function(e,r,t){var s=e.exports.Validator=t("./packages/node_modules/jsonschema/lib/validator.js");e.exports.ValidatorResult=t("./packages/node_modules/jsonschema/lib/helpers.js").ValidatorResult,e.exports.ValidatorResultError=t("./packages/node_modules/jsonschema/lib/helpers.js").ValidatorResultError,e.exports.ValidationError=t("./packages/node_modules/jsonschema/lib/helpers.js").ValidationError,e.exports.SchemaError=t("./packages/node_modules/jsonschema/lib/helpers.js").SchemaError,e.exports.SchemaScanResult=t("./packages/node_modules/jsonschema/lib/scan.js").SchemaScanResult,e.exports.scan=t("./packages/node_modules/jsonschema/lib/scan.js").scan,e.exports.validate=function(e,r,t){return(new s).validate(e,r,t)}},"./packages/node_modules/jsonschema/lib/scan.js":function(e,r,t){var s=t("./packages/node_modules/jsonschema/lib/helpers.js");function SchemaScanResult(e,r){this.id=e,this.ref=r}e.exports.SchemaScanResult=SchemaScanResult,e.exports.scan=function scan(e,r){function scanSchema(e,r){if(!r||"object"!=typeof r)return;if(r.$ref){let t=s.resolveUrl(e,r.$ref);return void(o[t]=o[t]?o[t]+1:0)}var a=r.$id||r.id;let n=s.resolveUrl(e,a);var i=a?n:e;if(i){if(i.indexOf("#")<0&&(i+="#"),t[i]){if(!s.deepCompareStrict(t[i],r))throw new Error("Schema <"+i+"> already exists with different definition");return t[i]}t[i]=r,"#"==i[i.length-1]&&(t[i.substring(0,i.length-1)]=r)}scanArray(i+"/items",Array.isArray(r.items)?r.items:[r.items]),scanArray(i+"/extends",Array.isArray(r.extends)?r.extends:[r.extends]),scanSchema(i+"/additionalItems",r.additionalItems),scanObject(i+"/properties",r.properties),scanSchema(i+"/additionalProperties",r.additionalProperties),scanObject(i+"/definitions",r.definitions),scanObject(i+"/patternProperties",r.patternProperties),scanObject(i+"/dependencies",r.dependencies),scanArray(i+"/disallow",r.disallow),scanArray(i+"/allOf",r.allOf),scanArray(i+"/anyOf",r.anyOf),scanArray(i+"/oneOf",r.oneOf),scanSchema(i+"/not",r.not)}function scanArray(e,r){if(Array.isArray(r))for(var t=0;t<r.length;t++)scanSchema(e+"/"+t,r[t])}function scanObject(e,r){if(r&&"object"==typeof r)for(var t in r)scanSchema(e+"/"+t,r[t])}var t={},o={};return scanSchema(e,r),new SchemaScanResult(t,o)}},"./packages/node_modules/jsonschema/lib/validator.js":function(e,r,t){var s=t("./packages/node_modules/jsonschema/lib/attribute.js"),o=t("./packages/node_modules/jsonschema/lib/helpers.js"),a=t("./packages/node_modules/jsonschema/lib/scan.js").scan,n=o.ValidatorResult,i=o.ValidatorResultError,p=o.SchemaError,c=o.SchemaContext,l=function Validator(){this.customFormats=Object.create(Validator.prototype.customFormats),this.schemas={},this.unresolvedRefs=[],this.types=Object.create(u),this.attributes=Object.create(s.validators)};function shouldResolve(e){var r="string"==typeof e?e:e.$ref;return"string"==typeof r&&r}l.prototype.customFormats={},l.prototype.schemas=null,l.prototype.types=null,l.prototype.attributes=null,l.prototype.unresolvedRefs=null,l.prototype.addSchema=function addSchema(e,r){var t=this;if(!e)return null;var s=a(r||"/",e),o=r||e.$id||e.id;for(var n in s.id)this.schemas[n]=s.id[n];for(var n in s.ref)this.unresolvedRefs.push(n);return this.unresolvedRefs=this.unresolvedRefs.filter(function(e){return void 0===t.schemas[e]}),this.schemas[o]},l.prototype.addSubSchemaArray=function addSubSchemaArray(e,r){if(Array.isArray(r))for(var t=0;t<r.length;t++)this.addSubSchema(e,r[t])},l.prototype.addSubSchemaObject=function addSubSchemaArray(e,r){if(r&&"object"==typeof r)for(var t in r)this.addSubSchema(e,r[t])},l.prototype.setSchemas=function setSchemas(e){this.schemas=e},l.prototype.getSchema=function getSchema(e){return this.schemas[e]},l.prototype.validate=function validate(e,r,t,s){if("boolean"!=typeof r&&"object"!=typeof r||null===r)throw new p("Expected `schema` to be an object or boolean");t||(t={});var l=r.$id||r.id;let u=o.resolveUrl(t.base,l||"");if(!s){(s=new c(r,t,[],u,Object.create(this.schemas))).schemas[u]||(s.schemas[u]=r);var d=a(u,r);for(var m in d.id){var f=d.id[m];s.schemas[m]=f}}var y;if(t.required&&void 0===e)return(y=new n(e,r,t,s)).addError("is required, but is undefined"),y;if(!(y=this.validateSchema(e,r,t,s)))throw new Error("Result undefined");if(t.throwAll&&y.errors.length)throw new i(y);return y},l.prototype.validateSchema=function validateSchema(e,r,t,a){var i=new n(e,r,t,a);if("boolean"==typeof r)!0===r?r={}:!1===r&&(r={type:[]});else if(!r)throw new Error("schema is undefined");if(r.extends)if(Array.isArray(r.extends)){var l={schema:r,ctx:a};r.extends.forEach(this.schemaTraverser.bind(this,l)),r=l.schema,l.schema=null,l.ctx=null,l=null}else r=o.deepMerge(r,this.superResolve(r.extends,a));var u=shouldResolve(r);if(u){var d=this.resolve(r,u,a),m=new c(d.subschema,t,a.path,d.switchSchema,a.schemas);return this.validateSchema(e,d.subschema,t,m)}var f=t&&t.skipAttributes||[];for(var y in r)if(!s.ignoreProperties[y]&&f.indexOf(y)<0){var g=null,h=this.attributes[y];if(h)g=h.call(this,e,r,t,a);else if(!1===t.allowUnknownAttributes)throw new p("Unsupported attribute: "+y,r);g&&i.importErrors(g)}if("function"==typeof t.rewrite){var k=t.rewrite.call(this,e,r,t,a);i.instance=k}return i},l.prototype.schemaTraverser=function schemaTraverser(e,r){e.schema=o.deepMerge(e.schema,this.superResolve(r,e.ctx))},l.prototype.superResolve=function superResolve(e,r){var t=shouldResolve(e);return t?this.resolve(e,t,r).subschema:e},l.prototype.resolve=function resolve(e,r,t){if(r=t.resolve(r),t.schemas[r])return{subschema:t.schemas[r],switchSchema:r};let s=new URL(r,"thismessage::/").hash;var a=s&&s.length&&r.substr(0,r.length-s.length);if(!a||!t.schemas[a])throw new p("no such schema <"+r+">",e);var n=o.objectGetPath(t.schemas[a],s.substr(1));if(void 0===n)throw new p("no such schema "+s+" located in <"+a+">",e);return{subschema:n,switchSchema:r}},l.prototype.testType=function validateType(e,r,t,s,o){if(void 0!==o){if(null===o)throw new p('Unexpected null in "type" keyword');if("function"==typeof this.types[o])return this.types[o].call(this,e);if(o&&"object"==typeof o){var a=this.validateSchema(e,o,t,s);return void 0===a||!(a&&a.errors.length)}return!0}};var u=l.prototype.types={};u.string=function testString(e){return"string"==typeof e},u.number=function testNumber(e){return"number"==typeof e&&isFinite(e)},u.integer=function testInteger(e){return"number"==typeof e&&e%1==0},u.boolean=function testBoolean(e){return"boolean"==typeof e},u.array=function testArray(e){return Array.isArray(e)},u.null=function testNull(e){return null===e},u.date=function testDate(e){return e instanceof Date},u.any=function testAny(e){return!0},u.object=function testObject(e){return e&&"object"==typeof e&&!Array.isArray(e)&&!(e instanceof Date)},e.exports=l},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-color-overlay.ts":function(e,r,t){t.r(r),t.d(r,{backgroundColorOverlayPropTypeUtil:function(){return a}});var s=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const a=(0,s.createPropUtils)("background-color-overlay",o.unknownChildrenSchema)},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-gradient-overlay.ts":function(e,r,t){t.r(r),t.d(r,{backgroundGradientOverlayPropTypeUtil:function(){return a}});var s=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const a=(0,s.createPropUtils)("background-gradient-overlay",o.unknownChildrenSchema)},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-overlay.ts":function(e,r,t){t.r(r),t.d(r,{backgroundImageOverlayPropTypeUtil:function(){return a}});var s=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const a=(0,s.createPropUtils)("background-image-overlay",o.unknownChildrenSchema)},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-position-offset.ts":function(e,r,t){t.r(r),t.d(r,{backgroundImagePositionOffsetPropTypeUtil:function(){return a}});var s=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const a=(0,s.createPropUtils)("background-image-position-offset",o.unknownChildrenSchema)},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-size-scale.ts":function(e,r,t){t.r(r),t.d(r,{backgroundImageSizeScalePropTypeUtil:function(){return a}});var s=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const a=(0,s.createPropUtils)("background-image-size-scale",o.unknownChildrenSchema)},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-overlay.ts":function(e,r,t){t.r(r),t.d(r,{backgroundOverlayItem:function(){return p},backgroundOverlayPropTypeUtil:function(){return c}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-color-overlay.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-gradient-overlay.ts"),i=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-overlay.ts");const p=a.backgroundColorOverlayPropTypeUtil.schema.or(n.backgroundGradientOverlayPropTypeUtil.schema).or(i.backgroundImageOverlayPropTypeUtil.schema),c=(0,o.createPropUtils)("background-overlay",s.z.array(p))},"./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background.ts":function(e,r,t){t.r(r),t.d(r,{backgroundPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("background",s.z.strictObject({color:a.unknownChildrenSchema,clip:a.unknownChildrenSchema,"background-overlay":a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/boolean.ts":function(e,r,t){t.r(r),t.d(r,{booleanPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("boolean",s.z.boolean().nullable())},"./packages/packages/libs/editor-props/src/prop-types/border-radius.ts":function(e,r,t){t.r(r),t.d(r,{borderRadiusPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("border-radius",s.z.strictObject({"start-start":a.unknownChildrenSchema,"start-end":a.unknownChildrenSchema,"end-start":a.unknownChildrenSchema,"end-end":a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/border-width.ts":function(e,r,t){t.r(r),t.d(r,{borderWidthPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("border-width",s.z.strictObject({"block-start":a.unknownChildrenSchema,"block-end":a.unknownChildrenSchema,"inline-start":a.unknownChildrenSchema,"inline-end":a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/box-shadow.ts":function(e,r,t){t.r(r),t.d(r,{boxShadowPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/shadow.ts");const n=(0,o.createPropUtils)("box-shadow",s.z.array(a.shadowPropTypeUtil.schema))},"./packages/packages/libs/editor-props/src/prop-types/classes.ts":function(e,r,t){t.r(r),t.d(r,{CLASSES_PROP_KEY:function(){return a},classesPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts");const a="classes",n=(0,o.createPropUtils)(a,s.z.array(s.z.string().regex(/^[a-z][a-z-_0-9]*$/i)))},"./packages/packages/libs/editor-props/src/prop-types/color-stop.ts":function(e,r,t){t.r(r),t.d(r,{colorStopPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("color-stop",s.z.strictObject({color:a.unknownChildrenSchema,offset:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/color.ts":function(e,r,t){t.r(r),t.d(r,{colorPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("color",s.z.string())},"./packages/packages/libs/editor-props/src/prop-types/date-time.ts":function(e,r,t){t.r(r),t.d(r,{DateTimePropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("date-time",s.z.strictObject({date:a.unknownChildrenSchema,time:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/dimensions.ts":function(e,r,t){t.r(r),t.d(r,{dimensionsPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("dimensions",s.z.strictObject({"block-start":a.unknownChildrenSchema,"block-end":a.unknownChildrenSchema,"inline-start":a.unknownChildrenSchema,"inline-end":a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/backdrop-filter.ts":function(e,r,t){t.r(r),t.d(r,{backdropFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter.ts");const n=(0,o.createPropUtils)("backdrop-filter",s.z.array(a.cssFilterFunctionPropUtil.schema))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/drop-shadow-filter.ts":function(e,r,t){t.r(r),t.d(r,{dropShadowFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("drop-shadow",s.z.object({xAxis:a.unknownChildrenSchema,yAxis:a.unknownChildrenSchema,blur:a.unknownChildrenSchema,color:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/blur-filter.ts":function(e,r,t){t.r(r),t.d(r,{blurFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("blur",s.z.strictObject({size:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/color-tone-filter.ts":function(e,r,t){t.r(r),t.d(r,{colorToneFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("color-tone",s.z.strictObject({size:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/hue-rotate-filter.ts":function(e,r,t){t.r(r),t.d(r,{hueRotateFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("hue-rotate",s.z.strictObject({size:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/intensity-filter.ts":function(e,r,t){t.r(r),t.d(r,{intensityFilterPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("intensity",s.z.strictObject({size:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter.ts":function(e,r,t){t.r(r),t.d(r,{cssFilterFunctionPropUtil:function(){return u},filterPropTypeUtil:function(){return d}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/string.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/drop-shadow-filter.ts"),i=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/blur-filter.ts"),p=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/color-tone-filter.ts"),c=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/hue-rotate-filter.ts"),l=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/intensity-filter.ts");const u=(0,o.createPropUtils)("css-filter-func",s.z.object({func:a.stringPropTypeUtil.schema,args:s.z.union([i.blurFilterPropTypeUtil.schema,l.intensityFilterPropTypeUtil.schema,p.colorToneFilterPropTypeUtil.schema,c.hueRotateFilterPropTypeUtil.schema,n.dropShadowFilterPropTypeUtil.schema])})),d=(0,o.createPropUtils)("filter",s.z.array(u.schema))},"./packages/packages/libs/editor-props/src/prop-types/flex.ts":function(e,r,t){t.r(r),t.d(r,{flexPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("flex",s.z.strictObject({flexGrow:a.unknownChildrenSchema,flexShrink:a.unknownChildrenSchema,flexBasis:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/gradient-color-stop.ts":function(e,r,t){t.r(r),t.d(r,{gradientColorStopPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/color-stop.ts");const n=(0,o.createPropUtils)("gradient-color-stop",s.z.array(a.colorStopPropTypeUtil.schema))},"./packages/packages/libs/editor-props/src/prop-types/html.ts":function(e,r,t){t.r(r),t.d(r,{htmlPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("html",s.z.string().nullable())},"./packages/packages/libs/editor-props/src/prop-types/image-attachment-id.ts":function(e,r,t){t.r(r),t.d(r,{imageAttachmentIdPropType:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("image-attachment-id",s.z.number())},"./packages/packages/libs/editor-props/src/prop-types/image-src.ts":function(e,r,t){t.r(r),t.d(r,{imageSrcPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("image-src",s.z.strictObject({id:a.unknownChildrenSchema,url:s.z.null()}).or(s.z.strictObject({id:s.z.null(),url:a.unknownChildrenSchema})))},"./packages/packages/libs/editor-props/src/prop-types/image.ts":function(e,r,t){t.r(r),t.d(r,{imagePropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("image",s.z.strictObject({src:a.unknownChildrenSchema,size:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/index.ts":function(e,r,t){t.r(r),t.d(r,{CLASSES_PROP_KEY:function(){return n.CLASSES_PROP_KEY},DateTimePropTypeUtil:function(){return E.DateTimePropTypeUtil},backdropFilterPropTypeUtil:function(){return L.backdropFilterPropTypeUtil},backgroundColorOverlayPropTypeUtil:function(){return w.backgroundColorOverlayPropTypeUtil},backgroundGradientOverlayPropTypeUtil:function(){return F.backgroundGradientOverlayPropTypeUtil},backgroundImageOverlayPropTypeUtil:function(){return S.backgroundImageOverlayPropTypeUtil},backgroundImagePositionOffsetPropTypeUtil:function(){return A.backgroundImagePositionOffsetPropTypeUtil},backgroundImageSizeScalePropTypeUtil:function(){return z.backgroundImageSizeScalePropTypeUtil},backgroundOverlayItem:function(){return U.backgroundOverlayItem},backgroundOverlayPropTypeUtil:function(){return U.backgroundOverlayPropTypeUtil},backgroundPropTypeUtil:function(){return T.backgroundPropTypeUtil},blurFilterPropTypeUtil:function(){return G.blurFilterPropTypeUtil},booleanPropTypeUtil:function(){return _.booleanPropTypeUtil},borderRadiusPropTypeUtil:function(){return o.borderRadiusPropTypeUtil},borderWidthPropTypeUtil:function(){return a.borderWidthPropTypeUtil},boxShadowPropTypeUtil:function(){return s.boxShadowPropTypeUtil},classesPropTypeUtil:function(){return n.classesPropTypeUtil},colorPropTypeUtil:function(){return i.colorPropTypeUtil},colorStopPropTypeUtil:function(){return j.colorStopPropTypeUtil},colorToneFilterPropTypeUtil:function(){return Y.colorToneFilterPropTypeUtil},cssFilterFunctionPropUtil:function(){return V.cssFilterFunctionPropUtil},dimensionsPropTypeUtil:function(){return d.dimensionsPropTypeUtil},dropShadowFilterPropTypeUtil:function(){return W.dropShadowFilterPropTypeUtil},filterPropTypeUtil:function(){return V.filterPropTypeUtil},flexPropTypeUtil:function(){return p.flexPropTypeUtil},gradientColorStopPropTypeUtil:function(){return O.gradientColorStopPropTypeUtil},htmlPropTypeUtil:function(){return Z.htmlPropTypeUtil},hueRotateFilterPropTypeUtil:function(){return H.hueRotateFilterPropTypeUtil},imageAttachmentIdPropType:function(){return l.imageAttachmentIdPropType},imagePropTypeUtil:function(){return c.imagePropTypeUtil},imageSrcPropTypeUtil:function(){return u.imageSrcPropTypeUtil},intensityFilterPropTypeUtil:function(){return B.intensityFilterPropTypeUtil},keyValuePropTypeUtil:function(){return x.keyValuePropTypeUtil},layoutDirectionPropTypeUtil:function(){return b.layoutDirectionPropTypeUtil},linkPropTypeUtil:function(){return v.linkPropTypeUtil},moveTransformPropTypeUtil:function(){return I.moveTransformPropTypeUtil},numberPropTypeUtil:function(){return m.numberPropTypeUtil},perspectiveOriginPropTypeUtil:function(){return K.perspectiveOriginPropTypeUtil},positionPropTypeUtil:function(){return $.positionPropTypeUtil},queryPropTypeUtil:function(){return C.queryPropTypeUtil},rotateTransformPropTypeUtil:function(){return D.rotateTransformPropTypeUtil},scaleTransformPropTypeUtil:function(){return q.scaleTransformPropTypeUtil},selectionSizePropTypeUtil:function(){return P.selectionSizePropTypeUtil},shadowPropTypeUtil:function(){return f.shadowPropTypeUtil},sizePropTypeUtil:function(){return y.sizePropTypeUtil},skewTransformPropTypeUtil:function(){return N.skewTransformPropTypeUtil},stringPropTypeUtil:function(){return g.stringPropTypeUtil},strokePropTypeUtil:function(){return h.strokePropTypeUtil},transformFunctionsPropTypeUtil:function(){return R.transformFunctionsPropTypeUtil},transformOriginPropTypeUtil:function(){return J.transformOriginPropTypeUtil},transformPropTypeUtil:function(){return M.transformPropTypeUtil},urlPropTypeUtil:function(){return k.urlPropTypeUtil}});var s=t("./packages/packages/libs/editor-props/src/prop-types/box-shadow.ts"),o=t("./packages/packages/libs/editor-props/src/prop-types/border-radius.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/border-width.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/classes.ts"),i=t("./packages/packages/libs/editor-props/src/prop-types/color.ts"),p=t("./packages/packages/libs/editor-props/src/prop-types/flex.ts"),c=t("./packages/packages/libs/editor-props/src/prop-types/image.ts"),l=t("./packages/packages/libs/editor-props/src/prop-types/image-attachment-id.ts"),u=t("./packages/packages/libs/editor-props/src/prop-types/image-src.ts"),d=t("./packages/packages/libs/editor-props/src/prop-types/dimensions.ts"),m=t("./packages/packages/libs/editor-props/src/prop-types/number.ts"),f=t("./packages/packages/libs/editor-props/src/prop-types/shadow.ts"),y=t("./packages/packages/libs/editor-props/src/prop-types/size.ts"),g=t("./packages/packages/libs/editor-props/src/prop-types/string.ts"),h=t("./packages/packages/libs/editor-props/src/prop-types/stroke.ts"),k=t("./packages/packages/libs/editor-props/src/prop-types/url.ts"),b=t("./packages/packages/libs/editor-props/src/prop-types/layout-direction.ts"),v=t("./packages/packages/libs/editor-props/src/prop-types/link.ts"),P=t("./packages/packages/libs/editor-props/src/prop-types/selection-size.ts"),T=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background.ts"),U=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-overlay.ts"),w=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-color-overlay.ts"),S=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-overlay.ts"),F=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-gradient-overlay.ts"),A=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-position-offset.ts"),z=t("./packages/packages/libs/editor-props/src/prop-types/background-prop-types/background-image-size-scale.ts"),_=t("./packages/packages/libs/editor-props/src/prop-types/boolean.ts"),j=t("./packages/packages/libs/editor-props/src/prop-types/color-stop.ts"),O=t("./packages/packages/libs/editor-props/src/prop-types/gradient-color-stop.ts"),x=t("./packages/packages/libs/editor-props/src/prop-types/key-value.ts"),E=t("./packages/packages/libs/editor-props/src/prop-types/date-time.ts"),$=t("./packages/packages/libs/editor-props/src/prop-types/position.ts"),C=t("./packages/packages/libs/editor-props/src/prop-types/query.ts"),Z=t("./packages/packages/libs/editor-props/src/prop-types/html.ts"),V=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter.ts"),M=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform.ts"),R=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions.ts"),I=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/move-transform.ts"),q=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/scale-transform.ts"),D=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/rotate-transform.ts"),N=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/skew-transform.ts"),J=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-origin.ts"),K=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/perspective-origin.ts"),L=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/backdrop-filter.ts"),W=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/drop-shadow-filter.ts"),G=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/blur-filter.ts"),B=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/intensity-filter.ts"),Y=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/color-tone-filter.ts"),H=t("./packages/packages/libs/editor-props/src/prop-types/filter-prop-types/filter-functions/hue-rotate-filter.ts")},"./packages/packages/libs/editor-props/src/prop-types/key-value.ts":function(e,r,t){t.r(r),t.d(r,{keyValuePropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("key-value",s.z.strictObject({key:a.unknownChildrenSchema,value:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/layout-direction.ts":function(e,r,t){t.r(r),t.d(r,{layoutDirectionPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("layout-direction",s.z.object({row:s.z.any(),column:s.z.any()}))},"./packages/packages/libs/editor-props/src/prop-types/link.ts":function(e,r,t){t.r(r),t.d(r,{linkPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("link",s.z.strictObject({destination:a.unknownChildrenSchema,isTargetBlank:a.unknownChildrenSchema,tag:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/number.ts":function(e,r,t){t.r(r),t.d(r,{numberPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("number",s.z.number().nullable())},"./packages/packages/libs/editor-props/src/prop-types/position.ts":function(e,r,t){t.r(r),t.d(r,{positionPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("object-position",s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/query.ts":function(e,r,t){t.r(r),t.d(r,{queryPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("query",s.z.strictObject({id:a.unknownChildrenSchema,label:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/selection-size.ts":function(e,r,t){t.r(r),t.d(r,{selectionSizePropTypeUtil:function(){return p}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/key-value.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/string.ts"),i=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const p=(0,o.createPropUtils)("selection-size",s.z.strictObject({selection:s.z.union([a.keyValuePropTypeUtil.schema,n.stringPropTypeUtil.schema]),size:i.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/shadow.ts":function(e,r,t){t.r(r),t.d(r,{shadowPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("shadow",s.z.strictObject({position:a.unknownChildrenSchema,hOffset:a.unknownChildrenSchema,vOffset:a.unknownChildrenSchema,blur:a.unknownChildrenSchema,spread:a.unknownChildrenSchema,color:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/size.ts":function(e,r,t){t.r(r),t.d(r,{sizePropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("size",s.z.strictObject({unit:s.z.enum(["px","em","rem","%","vw","vh","ch"]),size:s.z.number()}).or(s.z.strictObject({unit:s.z.enum(["deg","rad","grad","turn"]),size:s.z.number()})).or(s.z.strictObject({unit:s.z.enum(["s","ms"]),size:s.z.number()})).or(s.z.strictObject({unit:s.z.literal("auto"),size:s.z.literal("")})).or(s.z.strictObject({unit:s.z.literal("custom"),size:s.z.string()})))},"./packages/packages/libs/editor-props/src/prop-types/string.ts":function(e,r,t){t.r(r),t.d(r,{stringPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("string",s.z.string().nullable())},"./packages/packages/libs/editor-props/src/prop-types/stroke.ts":function(e,r,t){t.r(r),t.d(r,{strokePropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("stroke",s.z.strictObject({color:a.unknownChildrenSchema,width:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/perspective-origin.ts":function(e,r,t){t.r(r),t.d(r,{perspectiveOriginPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("perspective-origin",s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions.ts":function(e,r,t){t.r(r),t.d(r,{transformFunctionsPropTypeUtil:function(){return l}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/move-transform.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/rotate-transform.ts"),i=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/scale-transform.ts"),p=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/skew-transform.ts");const c=a.moveTransformPropTypeUtil.schema.or(i.scaleTransformPropTypeUtil.schema).or(n.rotateTransformPropTypeUtil.schema).or(p.skewTransformPropTypeUtil.schema),l=(0,o.createPropUtils)("transform-functions",s.z.array(c))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/move-transform.ts":function(e,r,t){t.r(r),t.d(r,{moveTransformPropTypeUtil:function(){return i}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/types.ts");const i=(0,o.createPropUtils)(n.TransformFunctionKeys.move,s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema,z:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/rotate-transform.ts":function(e,r,t){t.r(r),t.d(r,{rotateTransformPropTypeUtil:function(){return i}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/types.ts");const i=(0,o.createPropUtils)(n.TransformFunctionKeys.rotate,s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema,z:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/scale-transform.ts":function(e,r,t){t.r(r),t.d(r,{scaleTransformPropTypeUtil:function(){return i}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/number.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/types.ts");const i=(0,o.createPropUtils)(n.TransformFunctionKeys.scale,s.z.strictObject({x:a.numberPropTypeUtil.schema.nullable(),y:a.numberPropTypeUtil.schema.nullable(),z:a.numberPropTypeUtil.schema.nullable()}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-functions/skew-transform.ts":function(e,r,t){t.r(r),t.d(r,{skewTransformPropTypeUtil:function(){return i}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts"),n=t("./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/types.ts");const i=(0,o.createPropUtils)(n.TransformFunctionKeys.skew,s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform-origin.ts":function(e,r,t){t.r(r),t.d(r,{transformOriginPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("transform-origin",s.z.strictObject({x:a.unknownChildrenSchema,y:a.unknownChildrenSchema,z:a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/transform.ts":function(e,r,t){t.r(r),t.d(r,{transformPropTypeUtil:function(){return n}});var s=t("@elementor/schema"),o=t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),a=t("./packages/packages/libs/editor-props/src/prop-types/utils.ts");const n=(0,o.createPropUtils)("transform",s.z.strictObject({"transform-functions":a.unknownChildrenSchema,"transform-origin":a.unknownChildrenSchema,perspective:a.unknownChildrenSchema,"perspective-origin":a.unknownChildrenSchema}))},"./packages/packages/libs/editor-props/src/prop-types/transform-prop-types/types.ts":function(e,r,t){t.r(r),t.d(r,{TransformFunctionKeys:function(){return s}});const s={move:"transform-move",scale:"transform-scale",rotate:"transform-rotate",skew:"transform-skew"}},"./packages/packages/libs/editor-props/src/prop-types/url.ts":function(e,r,t){t.r(r),t.d(r,{urlPropTypeUtil:function(){return o}});var s=t("@elementor/schema");const o=(0,t("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts").createPropUtils)("url",s.z.string().nullable())},"./packages/packages/libs/editor-props/src/prop-types/utils.ts":function(e,r,t){t.r(r),t.d(r,{unknownChildrenSchema:function(){return o}});var s=t("@elementor/schema");const o=s.z.any().nullable()},"./packages/packages/libs/editor-props/src/types.ts":function(e,r,t){t.r(r)},"./packages/packages/libs/editor-props/src/utils/adjust-llm-prop-value-schema.ts":function(e,r,t){t.r(r),t.d(r,{adjustLlmPropValueSchema:function(){return adjustLlmPropValueSchema}});var s=t("./packages/packages/libs/editor-props/src/prop-types/index.ts");const ensureNotNull=(e,r)=>null===e?r:e,o={transformers:{}},adjustLlmPropValueSchema=(e,{transformers:r={},forceKey:t}=o)=>{const a=structuredClone(e);if("object"!=typeof a||null===a)return null;if(Array.isArray(a))return a.map(e=>adjustLlmPropValueSchema(e,{forceKey:t,transformers:r}));const n=a;if("$intention"in n&&delete n.$intention,t&&(n.$$type=t),"size"===n.$$type){const{value:e}=n;return{$$type:"size",value:{unit:"string"==typeof e.unit?e.unit:ensureNotNull(s.stringPropTypeUtil.extract(e.unit),"px"),size:"string"==typeof e.size||"number"==typeof e.size?e.size:ensureNotNull(s.stringPropTypeUtil.extract(e.size),s.numberPropTypeUtil.extract(e.size))}}}{const e=r?.[n.$$type];if(e)return e(n.value)}if("object"==typeof n.value)if(Array.isArray(n.value))n.value=adjustLlmPropValueSchema(n.value,{transformers:r});else{const{value:e}=n,t=a;t.value={},Object.entries(e).forEach(([e,s])=>{t.value[e]=adjustLlmPropValueSchema(s,{transformers:r})})}return a}},"./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts":function(e,r,t){t.r(r),t.d(r,{createArrayPropUtils:function(){return createArrayPropUtils},createPropUtils:function(){return createPropUtils},getPropSchemaFromCache:function(){return getPropSchemaFromCache}});var s=t("@elementor/schema");const o=new Map;function getPropSchemaFromCache(e){return o.get(e)}function createPropUtils(e,r){const t=s.z.strictObject({$$type:s.z.literal(e),value:r,disabled:s.z.boolean().optional()});function isValid(e){return t.safeParse(e).success}const a={extract:function extract(e){return isValid(e)?e.value:null},isValid:isValid,create:function create(r,t){const s="function"==typeof r?r:()=>r,{base:o,disabled:a}=t||{};if(!o)return{$$type:e,value:s(),...a&&{disabled:a}};if(!isValid(o))throw new Error(`Cannot create prop based on invalid value: ${JSON.stringify(o)}`);return{$$type:e,value:s(o.value),...a&&{disabled:a}}},schema:t,key:e};return o.set(e,a),a}function createArrayPropUtils(e,r,t){return createPropUtils(t||`${e}-array`,s.z.array(r))}},"./packages/packages/libs/editor-props/src/utils/filter-empty-values.ts":function(e,r,t){t.r(r),t.d(r,{filterEmptyValues:function(){return filterEmptyValues},isEmpty:function(){return isEmpty}});var s=t("./packages/packages/libs/editor-props/src/utils/is-transformable.ts");const filterEmptyValues=e=>isEmpty(e)?null:Array.isArray(e)?e.map(filterEmptyValues).filter(e=>!isEmpty(e)):"object"==typeof e?Object.fromEntries(Object.entries(e).map(([e,r])=>[e,filterEmptyValues(r)]).filter(([,e])=>!isEmpty(e))):e,isEmpty=e=>e&&(0,s.isTransformable)(e)?isEmpty(e.value):isNullish(e)||isNullishArray(e)||isNullishObject(e),isNullish=e=>null==e||""===e,isNullishArray=e=>Array.isArray(e)&&e.every(isEmpty),isNullishObject=e=>"object"==typeof e&&isNullishArray(Object.values(e))},"./packages/packages/libs/editor-props/src/utils/is-transformable.ts":function(e,r,t){t.r(r),t.d(r,{isTransformable:function(){return isTransformable}});var s=t("@elementor/schema");const o=s.z.object({$$type:s.z.string(),value:s.z.any(),disabled:s.z.boolean().optional()}),isTransformable=e=>o.safeParse(e).success},"./packages/packages/libs/editor-props/src/utils/llm-schema-to-props.ts":function(e,r,t){function jsonSchemaToPropType(e,r=e.key){const t={};return e.description&&(t.description=e.description),e.anyOf&&Array.isArray(e.anyOf)?function convertJsonSchemaToUnionPropType(e,r){const t={};if(!e.anyOf||!Array.isArray(e.anyOf))throw new Error("Invalid anyOf schema");for(const r of e.anyOf)if("object"===r.type&&r.properties&&r.properties.$$type&&r.properties.value){const e=r.properties.$$type;let s;if(!(e.enum&&Array.isArray(e.enum)&&e.enum.length>0))continue;s=e.enum[0];const o=convertJsonSchemaToPropType(r.properties.value);t[s]=o}return{kind:"union",prop_types:t,settings:{},meta:r}}(e,t):"object"===e.type&&e.properties?function convertJsonSchemaToObjectPropType(e,r,t=e.key){const s={};if(!e.properties)return{kind:"object",key:t,shape:{},settings:{},meta:r};const o=Array.isArray(e.required)?e.required:[];for(const[r,a]of Object.entries(e.properties)){const e=convertJsonSchemaToPropType(a,t);o.includes(r)&&(e.settings={...e.settings,required:!0}),s[r]=e}return{kind:"object",key:t||"object",shape:s,settings:{},meta:r}}(e,t,r):"array"===e.type&&e.items?function convertJsonSchemaToArrayPropType(e,r,t=e.key){if(!e.items)throw new Error("Array schema must have items property");const s=convertJsonSchemaToPropType(e.items);return{kind:"array",key:t||"array",item_prop_type:s,settings:{},meta:r}}(e,t,r):function convertJsonSchemaToPlainPropType(e,r,t=e.key){const s={};let o=t||"string";"number"===e.type?o="number":"boolean"===e.type?o="boolean":"string"===e.type&&(o="string");Array.isArray(e.enum)&&(s.enum=e.enum);return{kind:"plain",key:o,settings:s,meta:r}}(e,t,r)}function convertJsonSchemaToPropType(e,r){return jsonSchemaToPropType(e,r)}function jsonSchemaToPropsSchema(e){const r={};if("object"!==e.type||!e.properties)throw new Error("Root schema must be an object with properties");for(const[t,s]of Object.entries(e.properties))r[t]=convertJsonSchemaToPropType(s,t);return r}t.r(r),t.d(r,{jsonSchemaToPropType:function(){return jsonSchemaToPropType},jsonSchemaToPropsSchema:function(){return jsonSchemaToPropsSchema}})},"./packages/packages/libs/editor-props/src/utils/merge-props.ts":function(e,r,t){function mergeProps(e,r){let t={};return Array.isArray(e)||(t=structuredClone(e)),Object.entries(r).forEach(([e,r])=>{null==r?delete t[e]:t[e]=r}),t}t.r(r),t.d(r,{mergeProps:function(){return mergeProps}})},"./packages/packages/libs/editor-props/src/utils/prop-dependency-utils.ts":function(e,r,t){t.r(r),t.d(r,{evaluateTerm:function(){return evaluateTerm},extractValue:function(){return extractValue},isDependency:function(){return isDependency},isDependencyMet:function(){return isDependencyMet}});var s=t("./packages/packages/libs/editor-props/src/utils/is-transformable.ts");function isDependencyMet(e,r){if(!e?.terms.length)return{isMet:!0};const{relation:t,terms:s}=e,o=function getRelationMethod(e){switch(e){case"or":return"some";case"and":return"every";default:throw new Error(`Relation not supported ${e}`)}}(t),a=[];return{isMet:s[o](e=>{const t=isDependency(e)?isDependencyMet(e,r).isMet:evaluateTerm(e,extractValue(e.path,r,e.nestedPath)?.value);return t||a.push(e),t}),failingDependencies:a}}function evaluateTerm(e,r){const{value:t,operator:s}=e;switch(s){case"eq":case"ne":return r===t==("eq"===s);case"gt":case"lte":return!(!isNumber(r)||!isNumber(t))&&Number(r)>Number(t)==("gt"===s);case"lt":case"gte":return!(!isNumber(r)||!isNumber(t))&&Number(r)<Number(t)==("lt"===s);case"in":case"nin":return!!Array.isArray(t)&&t.includes(r)===("in"===s);case"contains":case"ncontains":return!!("string"==typeof r&&"string"==typeof t||Array.isArray(r))&&"contains"===s===r.includes(t);case"exists":case"not_exist":return"exists"===s===(!!r||0===r||!1===r);default:return!0}}function isNumber(e){return"number"==typeof e&&!isNaN(e)}function extractValue(e,r,t=[]){const o=e.reduce((r,t,o)=>{const a=r?.[t];return o!==e.length-1&&(0,s.isTransformable)(a)?a.value??null:a},r);if(!t?.length)return o;return{$$type:"unknown",value:t.reduce((e,r)=>e?.[r],o?.value)}}function isDependency(e){return"terms"in e}},"./packages/packages/libs/editor-props/src/utils/props-to-llm-schema.ts":function(e,r,t){function propTypeToJsonSchema(e){const r=e.meta?.description,t={};switch(r&&(t.description=r),null!==e.initial_value&&void 0!==e.initial_value&&(t.examples=[e.initial_value]),e.kind){case"union":return function convertUnionPropType(e,r){const t=structuredClone(r),s=e.prop_types||{},o=[];for(const[e,r]of Object.entries(s)){if("dynamic"===e||"overridable"===e)continue;const t=convertPropTypeToJsonSchema(r);o.push(t)}o.length>0&&(t.anyOf=o);const a=e.meta?.description;a&&(t.description=a);return t}(e,t);case"object":return function convertObjectPropType(e,r){const t=structuredClone(r);t.type="object";const s={properties:{$$type:{type:"string",const:e.key},value:{type:"object",properties:{},additionalProperties:!1}}},o=["$$type","value"],a=[],n=e.shape||{};for(const[e,r]of Object.entries(n)){const t=propTypeToJsonSchema(r);!0===r.settings?.required&&a.push(e),s.properties.value.properties&&(s.properties.value.properties[e]=t)}t.required=o,a.length>0&&(s.properties.value.required=a);return{...t,...s}}(e,t);case"array":return function convertArrayPropType(e,r){const t=structuredClone(r);let s;t.type="object";const o=e.item_prop_type;o&&(s=convertPropTypeToJsonSchema(o));return t.properties={$$type:{type:"string",const:e.key},value:{type:"array",...s?{items:s}:{}}},t}(e,t);default:return function convertPlainPropType(e,r){const t={...r};if(!Object.hasOwn(e,"kind"))throw new Error(`PropType kind is undefined for propType with key: ${e.key??"[unknown key]"}`);const s=e.settings?.enum||[];switch(e.kind){case"string":case"number":case"boolean":return{...t,type:"object",properties:{$$type:{type:"string",const:e.key??e.kind},value:{type:e.kind,...s.length>0?{enum:s}:{}}},required:["$$type","value"]};default:return{...t,type:"object",$$type:e.kind,value:{type:e.kind}}}}(e,t)}}function convertPropTypeToJsonSchema(e){return propTypeToJsonSchema(e)}function propsSchemaToJsonSchema(e){const r={type:"object",properties:{}};for(const[t,s]of Object.entries(e)){if(!isPropKeyConfigurable(t))continue;const e=convertPropTypeToJsonSchema(s);r.properties&&(r.properties[t]=e)}return r}t.r(r),t.d(r,{configurableKeys:function(){return configurableKeys},enrichWithIntention:function(){return enrichWithIntention},isPropKeyConfigurable:function(){return isPropKeyConfigurable},nonConfigurablePropKeys:function(){return s},propTypeToJsonSchema:function(){return propTypeToJsonSchema},propsSchemaToJsonSchema:function(){return propsSchemaToJsonSchema},removeIntention:function(){return removeIntention}});const s=["_cssid","classes","attributes"];function isPropKeyConfigurable(e){return!s.includes(e)}function configurableKeys(e){return Object.keys(e).filter(isPropKeyConfigurable)}function enrichWithIntention(e,r="Describe the desired outcome"){const t=structuredClone(e);return t.properties?(t.properties.$intention={type:"string",description:r},t.required=[...t.required||[],"$intention"],t):e}function removeIntention(e){const r=structuredClone(e);return r.properties?(delete r.properties.$intention,r.required&&(r.required=r.required.filter(e=>"$intention"!==e)),r):e}},"./packages/packages/libs/editor-props/src/utils/validate-prop-value.ts":function(e,r,t){t.r(r),t.d(r,{validatePropValue:function(){return validatePropValue},validatePropValueDetailed:function(){return validatePropValueDetailed}});var s=t("./packages/node_modules/jsonschema/lib/index.js"),o=t("./packages/packages/libs/editor-props/src/utils/props-to-llm-schema.ts");function processValidationError(e){const r={path:e.path,message:e.message,schema:e.schema,instance:e.instance,name:e.name};if("anyOf"===e.name&&e.schema&&"object"==typeof e.schema&&"anyOf"in e.schema){const t=(e.schema.anyOf||[]).map((r,t)=>{const o=(0,s.validate)(e.instance,r);let a=`variant-${t}`;if(r&&"object"==typeof r&&"properties"in r&&r.properties&&"object"==typeof r.properties&&"$$type"in r.properties){const e=r.properties.$$type;e&&"object"==typeof e&&"const"in e&&"string"==typeof e.const&&(a=e.const)}return{discriminator:a,errors:o.errors.map(processValidationError)}});r.variants=t}return r}function formatDetailedErrors(e,r=""){const t=[];for(const s of e){const e=s.path.length>0?s.path.join("."):"root";if(t.push(`${r}Error at ${e}: ${s.message}`),s.variants&&s.variants.length>0){t.push(`${r}  Tried ${s.variants.length} variant(s):`);for(const e of s.variants)if(t.push(`${r}    - ${e.discriminator}:`),0===e.errors.length)t.push(`${r}        (no errors - this variant matched!)`);else for(const s of e.errors){const e=s.path.length>0?s.path.join("."):"root";t.push(`${r}        ${e}: ${s.message}`),s.variants&&s.variants.length>0&&t.push(formatDetailedErrors([s],`${r}        `))}}}return t.join("\n")}const validatePropValue=(e,r)=>{const t=(0,o.propTypeToJsonSchema)(e);if(null===r)return{valid:!0,errors:[],errorMessages:[],jsonSchema:JSON.stringify((0,o.propTypeToJsonSchema)(e))};const a=(0,s.validate)(r,t),n=a.errors.map(processValidationError);return{valid:a.valid,errors:a.errors,errorMessages:formatDetailedErrors(n),jsonSchema:JSON.stringify(t)}},validatePropValueDetailed=(e,r)=>{const t=(0,o.propTypeToJsonSchema)(e),a=(0,s.validate)(r,t),n=a.errors.map(processValidationError);return{valid:a.valid,errors:n,errorMessages:n.map(e=>e.message),formattedErrors:formatDetailedErrors(n),jsonSchema:JSON.stringify(t)}}},"@elementor/schema":function(e){e.exports=window.elementorV2.schema}},r={};function __webpack_require__(t){var s=r[t];if(void 0!==s)return s.exports;var o=r[t]={exports:{}};return e[t](o,o.exports,__webpack_require__),o.exports}__webpack_require__.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(r,{a:r}),r},__webpack_require__.d=function(e,r){for(var t in r)__webpack_require__.o(r,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:r[t]})},__webpack_require__.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var t={};!function(){__webpack_require__.r(t),__webpack_require__.d(t,{CLASSES_PROP_KEY:function(){return a.CLASSES_PROP_KEY},DateTimePropTypeUtil:function(){return a.DateTimePropTypeUtil},Schema:function(){return u},backdropFilterPropTypeUtil:function(){return a.backdropFilterPropTypeUtil},backgroundColorOverlayPropTypeUtil:function(){return a.backgroundColorOverlayPropTypeUtil},backgroundGradientOverlayPropTypeUtil:function(){return a.backgroundGradientOverlayPropTypeUtil},backgroundImageOverlayPropTypeUtil:function(){return a.backgroundImageOverlayPropTypeUtil},backgroundImagePositionOffsetPropTypeUtil:function(){return a.backgroundImagePositionOffsetPropTypeUtil},backgroundImageSizeScalePropTypeUtil:function(){return a.backgroundImageSizeScalePropTypeUtil},backgroundOverlayItem:function(){return a.backgroundOverlayItem},backgroundOverlayPropTypeUtil:function(){return a.backgroundOverlayPropTypeUtil},backgroundPropTypeUtil:function(){return a.backgroundPropTypeUtil},blurFilterPropTypeUtil:function(){return a.blurFilterPropTypeUtil},booleanPropTypeUtil:function(){return a.booleanPropTypeUtil},borderRadiusPropTypeUtil:function(){return a.borderRadiusPropTypeUtil},borderWidthPropTypeUtil:function(){return a.borderWidthPropTypeUtil},boxShadowPropTypeUtil:function(){return a.boxShadowPropTypeUtil},classesPropTypeUtil:function(){return a.classesPropTypeUtil},colorPropTypeUtil:function(){return a.colorPropTypeUtil},colorStopPropTypeUtil:function(){return a.colorStopPropTypeUtil},colorToneFilterPropTypeUtil:function(){return a.colorToneFilterPropTypeUtil},createArrayPropUtils:function(){return n.createArrayPropUtils},createPropUtils:function(){return n.createPropUtils},cssFilterFunctionPropUtil:function(){return a.cssFilterFunctionPropUtil},dimensionsPropTypeUtil:function(){return a.dimensionsPropTypeUtil},dropShadowFilterPropTypeUtil:function(){return a.dropShadowFilterPropTypeUtil},evaluateTerm:function(){return l.evaluateTerm},extractValue:function(){return l.extractValue},filterEmptyValues:function(){return i.filterEmptyValues},filterPropTypeUtil:function(){return a.filterPropTypeUtil},flexPropTypeUtil:function(){return a.flexPropTypeUtil},getPropSchemaFromCache:function(){return n.getPropSchemaFromCache},gradientColorStopPropTypeUtil:function(){return a.gradientColorStopPropTypeUtil},htmlPropTypeUtil:function(){return a.htmlPropTypeUtil},hueRotateFilterPropTypeUtil:function(){return a.hueRotateFilterPropTypeUtil},imageAttachmentIdPropType:function(){return a.imageAttachmentIdPropType},imagePropTypeUtil:function(){return a.imagePropTypeUtil},imageSrcPropTypeUtil:function(){return a.imageSrcPropTypeUtil},intensityFilterPropTypeUtil:function(){return a.intensityFilterPropTypeUtil},isDependency:function(){return l.isDependency},isDependencyMet:function(){return l.isDependencyMet},isEmpty:function(){return i.isEmpty},isTransformable:function(){return p.isTransformable},keyValuePropTypeUtil:function(){return a.keyValuePropTypeUtil},layoutDirectionPropTypeUtil:function(){return a.layoutDirectionPropTypeUtil},linkPropTypeUtil:function(){return a.linkPropTypeUtil},mergeProps:function(){return c.mergeProps},moveTransformPropTypeUtil:function(){return a.moveTransformPropTypeUtil},numberPropTypeUtil:function(){return a.numberPropTypeUtil},perspectiveOriginPropTypeUtil:function(){return a.perspectiveOriginPropTypeUtil},positionPropTypeUtil:function(){return a.positionPropTypeUtil},queryPropTypeUtil:function(){return a.queryPropTypeUtil},rotateTransformPropTypeUtil:function(){return a.rotateTransformPropTypeUtil},scaleTransformPropTypeUtil:function(){return a.scaleTransformPropTypeUtil},selectionSizePropTypeUtil:function(){return a.selectionSizePropTypeUtil},shadowPropTypeUtil:function(){return a.shadowPropTypeUtil},sizePropTypeUtil:function(){return a.sizePropTypeUtil},skewTransformPropTypeUtil:function(){return a.skewTransformPropTypeUtil},stringPropTypeUtil:function(){return a.stringPropTypeUtil},strokePropTypeUtil:function(){return a.strokePropTypeUtil},transformFunctionsPropTypeUtil:function(){return a.transformFunctionsPropTypeUtil},transformOriginPropTypeUtil:function(){return a.transformOriginPropTypeUtil},transformPropTypeUtil:function(){return a.transformPropTypeUtil},urlPropTypeUtil:function(){return a.urlPropTypeUtil}});var e=__webpack_require__("./packages/packages/libs/editor-props/src/utils/adjust-llm-prop-value-schema.ts"),r=__webpack_require__("./packages/packages/libs/editor-props/src/utils/llm-schema-to-props.ts"),s=__webpack_require__("./packages/packages/libs/editor-props/src/utils/props-to-llm-schema.ts"),o=__webpack_require__("./packages/packages/libs/editor-props/src/utils/validate-prop-value.ts"),a=(__webpack_require__("./packages/packages/libs/editor-props/src/types.ts"),__webpack_require__("./packages/packages/libs/editor-props/src/prop-types/index.ts")),n=__webpack_require__("./packages/packages/libs/editor-props/src/utils/create-prop-utils.ts"),i=__webpack_require__("./packages/packages/libs/editor-props/src/utils/filter-empty-values.ts"),p=__webpack_require__("./packages/packages/libs/editor-props/src/utils/is-transformable.ts"),c=__webpack_require__("./packages/packages/libs/editor-props/src/utils/merge-props.ts"),l=__webpack_require__("./packages/packages/libs/editor-props/src/utils/prop-dependency-utils.ts");const u={jsonSchemaToPropType:r.jsonSchemaToPropType,propTypeToJsonSchema:s.propTypeToJsonSchema,adjustLlmPropValueSchema:e.adjustLlmPropValueSchema,isPropKeyConfigurable:s.isPropKeyConfigurable,nonConfigurablePropKeys:s.nonConfigurablePropKeys,configurableKeys:s.configurableKeys,validatePropValue:o.validatePropValue,enrichWithIntention:s.enrichWithIntention,removeIntention:s.removeIntention}}(),(window.elementorV2=window.elementorV2||{}).editorProps=t}(),window.elementorV2.editorProps?.init?.();
//# sourceMappingURL=editor-props.js.map